

PROCEDURE NETWORKSCHEDULING(
       N,INF         :INTEGER;
   VAR NRC,ORDER,TIME:ARRN;
   VAR NR            :ARRN1;
   VAR INARC         :ARRM;
   VAR COUNT         :INTEGER;
   VAR LONGESTPATH   :ARRN);

   VAR DELTA,I,I1,J,K,L,P,Q,R,S,T,T1,T2:INTEGER;
       B,BACK                          :BOOLEAN;
       D,DELARR,E,F,OPTORD,PI,REVORD   :ARRN;
       LABELS,LL,MATE,TREE,UL          :ARRM;
       CRITARC                         :ARRMAX;

   PROCEDURE DMATES;
      { THIS PROCEDURE MATCHES DISJUNCTIVE ARCS OF THE SAME PAIR }
      VAR I,J,K,L:INTEGER;
   BEGIN
      FOR I:=1 TO N DO BEGIN
         PI[I]:=NRC[I]+1;  D[I]:=PI[I];
         E[I]:=NR[I+1]-1
      END;
      FOR I:=1 TO N DO
         FOR K:=PI[I] TO E[I] DO  BEGIN
            J:=INARC[K];  L:=D[J];
            LABELS[L]:=I;  CRITARC[L]:=K;
            D[J]:=L+1
         END;  { FOR K, I }
      FOR I:=1 TO N DO BEGIN
         FOR K:=PI[I] TO E[I] DO D[LABELS[K]]:=CRITARC[K];
         FOR K:=PI[I] TO E[I] DO MATE[K]:=D[INARC[K]]
      END
   END;  { DMATES }

   PROCEDURE CRITICALPATH(LAB:INTEGER;VAR D,E:ARRN);
      { THIS PROCEDURE FINDS THE LENGHT OF LONGEST PATHS
        FROM SOURCE TO ALL OTHER NODES IN THE NETWORK
        FORMED BY ARCS WITH LABELS AT LEAST LAB }
      VAR H,I,J,K,L,R,S:INTEGER;
   BEGIN
      D[1]:=0;
      FOR K:=2 TO N DO BEGIN
         J:=ORDER[K];
         R:=-1;
         FOR L:=NR[J] TO NR[J+1]-1 DO
            IF LABELS[L] >= LAB THEN BEGIN
               I:=INARC[L];  S:=D[I]+TIME[I];
               IF S > R THEN BEGIN R:=S;  H:=L END
            END;
         D[J]:=R;  E[J]:=H
      END  { FOR K }
   END;  { CRITICALPATH }

   PROCEDURE REORDER(I,J:INTEGER);
      { THIS PROCEDURE MODIFIES TOPOLOGICAL ORDERING AFTER
        SWITCHING DISJUNCTIVE ARC (I,J) FOR ITS REVERSE }
      VAR K,L,P,Q,R,S,U,V:INTEGER;
          NODORD         :ARRN;

      PROCEDURE MOVE(VAR G,H:INTEGER);
         { THIS PROCEDURE MOVES NODE G TO POSITION H IN ARRAY ORDER }
      BEGIN
         ORDER[H]:=G;  REVORD[G]:=H;  H:=H-1
      END;  { MOVE }

   BEGIN
      K:=REVORD[I];  L:=REVORD[J];
      ORDER[L]:=-J;
      Q:=L;
      WHILE Q > K+1 DO BEGIN
         R:=ORDER[Q];
         IF R < 0 THEN
            FOR U:=NR[-R] TO NR[-R+1]-1 DO BEGIN
               S:=INARC[U];  V:=REVORD[S];
               IF (V > K) AND (LABELS[U] >= 2) THEN ORDER[V]:=-S
            END;  { FOR U, IF R < 0 }
         Q:=Q-1
      END;  { WHILE Q > K+1 }
      P:=0;
      FOR U:=K+1 TO L DO
         IF ORDER[U] < 0 THEN BEGIN
            P:=P+1;  NODORD[P]:=-ORDER[U]
         END;
      Q:=L;
      FOR U:=L-1 DOWNTO K DO
          IF ORDER[U] > 0 THEN MOVE(ORDER[U],Q);
      FOR U:=P DOWNTO 1 DO MOVE(NODORD[U],Q)
   END;  { REORDER }

BEGIN                                                   { MAIN BODY }
   DMATES;                                         { INITIALIZATION }
   FOR I:=1 TO N DO REVORD[ORDER[I]]:=I;
   FOR I:=1 TO N DO BEGIN                          { SETTING LABELS }
      FOR J:=NR[I] TO NRC[I] DO LABELS[J]:=3;
      P:=REVORD[I];
      FOR J:=NRC[I]+1 TO NR[I+1]-1 DO BEGIN
         Q:=REVORD[INARC[J]];
         IF P > Q THEN LABELS[J]:=2
         ELSE LABELS[J]:=1
      END  { FOR J }
   END;  { FOR I }
   R:=0;                 { R IS THE LEVEL NUMBER IN THE SEARCH TREE }
   K:=0;  T:=INF;  COUNT:=0;
   REPEAT  { R = 0 }               { UNTIL THE SEARCH IS EXCHAUSTED }
      CRITICALPATH(3,D,E);
      BACK:=D[N] >= T;
      B:=TRUE;
      IF NOT BACK THEN BEGIN
         CRITICALPATH(2,PI,E);
         IF PI[N] < T THEN BEGIN       { UPDATING THE BEST SOLUTION }
            FOR I:=1 TO N DO OPTORD[I]:=ORDER[I];
            T:=PI[N]
         END;
         J:=N;  L:=K+1;
         WHILE J <> 1 DO BEGIN
            I1:=E[J];  I:=INARC[I1];
            IF LABELS[I1] = 2 THEN BEGIN
                                { ARC (I,J) IS DISJUNCTIVE AND FREE }
               LABELS[I1]:=1;
               CRITICALPATH(2,D,F);    { LONGEST PATH WITH NO (I,J) }
               LABELS[I1]:=2;
               T1:=D[J]-PI[I];  T2:=D[N]-D[I]-PI[N]+PI[J];
               DELTA:=T1+T2+TIME[J];
               IF T1 > DELTA THEN DELTA:=T1;
               IF T2 > DELTA THEN DELTA:=T2;
               DELTA:=DELTA-TIME[I];
               P:=L;  Q:=1;
               WHILE (P <= K) AND (DELARR[Q] <= DELTA) DO BEGIN
                  P:=P+1;   Q:=Q+1
               END;
               K:=K+1;  Q:=K-L+1;
               FOR S:=K DOWNTO P+1 DO BEGIN
                  CRITARC[S]:=CRITARC[S-1];
                  DELARR[Q]:=DELARR[Q-1];
                  Q:=Q-1
               END;  { FOR S }
               CRITARC[P]:=I1;  DELARR[Q]:=DELTA
            END;  { IF LABELS[I1] = 2 - FREE ARC (I,J) }
            J:=I
         END;  { WHILE J <> 1 - TRAVERSING CRITICAL PATH }
         B:=L > K;
         IF NOT B THEN BEGIN
            R:=R+1;  LL[R]:=L;  UL[R]:=K
         END
      END;  { IF NOT BACK }
      IF BACK OR B THEN
         WHILE B AND (R > 0) DO BEGIN           { BACKTRACKING STEP }
            P:=TREE[R];  Q:=MATE[P];
            LABELS[P]:=1;  LABELS[Q]:=4;
            REORDER(INARC[P],INARC[Q]);
            B:=LL[R] > UL[R];
            IF B THEN BEGIN
               R:=R-1;
               IF R > 0 THEN
                  FOR S:=UL[R]+1 TO UL[R+1] DO LABELS[CRITARC[S]]:=2
            END  { IF B }
         END;  { WHILE B AND (R > 0), IF BACK OR B }
      IF R > 0 THEN BEGIN                            { FORVARD MOVE }
         K:=UL[R];
         COUNT:=COUNT+1;  I1:=LL[R];
         P:=CRITARC[I1];  LL[R]:=I1+1;  Q:=MATE[P];
         LABELS[Q]:=3;  LABELS[P]:=0;
         REORDER(INARC[P],INARC[Q]);
         TREE[R]:=Q
      END  { IF R > 0 }
   UNTIL R = 0;
   FOR I:=1 TO N DO BEGIN                { OUTPUT THE BEST SOLUTION }
      ORDER[I]:=OPTORD[I];  REVORD[ORDER[I]]:=I
   END;
   FOR I:=1 TO N DO BEGIN
      P:=REVORD[I];
      FOR J:=NRC[I]+1 TO NR[I+1]-1 DO BEGIN
         Q:=REVORD[INARC[J]];
         IF P > Q THEN LABELS[J]:=2
         ELSE LABELS[J]:=1
      END  { FOR J }
   END;  { FOR I }
   CRITICALPATH(2,LONGESTPATH,E)
END;  { NETWORKSCHEDULING }


